'Version 2.0 May 2015 Taken over WIA repeater file creation
'Version 1.5 Dec 2013 Created LongLat Merge Version and improved handling of Notes
'Version 1.4 Sept 2013 Callsign filtering bug. 1 call area filter now works
'Version 1.3 Feb 2013 Script now ignores blank lines
'Version 1.2 July 2012 Added the /f filter to limit output to a list of states
'Version 1.1 June 2012 Fixed mismatched header columns and repeater columns, Added other sections
'Version 1.0 March 2012 - Original
'Copyright (c) Steve Ireland 2012
'WiaRep2Text.vbs and all other variants that start with WiaRep2 were originaly written by Steve Ireland VK2MD (vk2md@wia.org.au)
'This application can be freely distributed, modified and used by anybody for both private and commercial purposes.

'If you make changes to the software please add the statements above to your source code to achnowledge Steve Ireland VK2MD as the original author and to freely 
'distribute your software.
'Please Please Please do not use the file name prefix WiaRep2 or WiaRepTo as I use this prefix on software that I maintain.
'In essance the naming convention is the only intellectual property that I assert purely for maintenance purposes.
'Have fun. Steve March 2012


'This script will read the WIA Repeater Directory CSV file write it to console
'It is intended as a training exercise!

'To run this script 
'   cscript WiaRep2Text.vbs "Repeater Directory 120214.csv"
'   use the /f option to filter on states. eg /f:vk1,vk2,vk3 will only output repeaters from the listed states

 
Option Explicit
Dim args
Const ForReading = 1, ForWriting = 2, ForAppending = 8
Main

Sub Main()
    If ParseArgs() < 1 Then
        wscript.echo "Usage: cscript WiaRep2Text.vbs ""WIA Repeater Directory ????.csv"""
                wscript.echo "       Use option /f to filter states"

        wscript.echo "Pipe to a text file by appending >wiarep.txt"
        Exit Sub
    End If


    'Go load the WIA repeater file using the passed in file name in arg0
    Dim bands
    bands = LoadWia(args("arg0"))

    wscript.echo "WiaRep2Text of file " & args("arg0")

    'The WIA repeater csv will evolve over time so just test how big it is wrt the size it was when the script was developed
    If Not (UBound(bands) = 34 or UBound(bands) = 42) Then
        wscript.echo ""
        wscript.echo "Warning. The number of band sections in the WIA script has changed from 40."
        wscript.echo "It doesn't matter for this application."
    End If


    wscript.echo ""
    wscript.echo "Total Number of band sections " & CStr(UBound(bands))
    wscript.echo ""
    wscript.echo ""
    wscript.echo ""


    'Get the first repeater to get the headers
    Dim repeaterDict
    Set repeaterDict = bands(0)(0) '<- using an index to retrieve a repeater dictionary object in this case

    'Use enumeration (For Each) to access the memory structure and print out the whole structure
    'The first loop duplicates the input file exactely

    'build up the header text
    Dim key
    Dim HeaderLine
    headerLine = ""
    For Each key in repeaterDict.Keys
        headerLine = headerLine & Quotes(key) & " " 'the keys are the header names
    Next
    wscript.echo headerLine
    wscript.echo String(repeaterDict.Count,",")

    Dim band
    For Each band in bands
        Dim repeater
        For Each repeater in band
            If RepeaterCallsignInFilter(repeater) = True Then 'show use of the call area filter
                'Dictionary items can be indexed by name (very convenient) which are used as the dictionary keys
                wscript.echo _
                    DashOrValue(repeater("Output")) & "," & _
                    DashOrValue(repeater("Input")) & "," & _
                    Quotes(repeater("Call")) & "," & _
                    Quotes(repeater("Location")) & "," & _
                    Quotes(repeater("Service Area")) & "," & _
                    Quotes(repeater("S")) & "," & _
                    DashOrValue(repeater("ERP")) & "," & _
                    DashOrValue(repeater("HASL")) & "," & _
                    DashOrValue(repeater("T/O")) & "," & _
                    Quotes(repeater("Sp")) & "," & _
                    DashOrValue(repeater("Tone")) & "," &  _
                    Notes(repeater("Notes"))
            End If
        Next
        wscript.echo String(repeaterDict.Count,",")
    Next

    wscript.echo ""
    wscript.echo ""
    wscript.echo ""


    'Using old fashioned looping for fun to get the same result as above.
    ' In real use use enumerator syntax above (For Each) it's better and faster.
    'lots of i's, j's and k's so hold onto your hats
    'This loop creates a more readable listing

    'Build up the header text
    headerLine = ""
    Dim keys
    keys = repeaterDict.Keys
    Dim k 
    For k=0 To repeaterDict.Count - 1
        headerLine = headerLine & keys(k) & " " 'the keys are the header names
    Next

    Dim i
    For i=0 to UBound(bands)

        'output the header on each band section
        wscript.echo headerLine

        Dim j
        For j=0 to UBound(bands(i))

            'Dictionary items can be iterated
            Dim items
            items = bands(i)(j).Items
            Dim Line
            Line = ""
            For k=0 to bands(i)(j).Count-1
                Line = Line & items(k) & " "
            Next
            wscript.echo Line

        Next
        wscript.echo
    Next

End Sub

Function Quotes(value)
    Quotes = """" & value & """"
End Function

Function DashOrValue(value)
    IF Trim(value) = "-" Or Trim(value) = "" Or Trim(value) = " " Then
        DashOrValue = Quotes("-")
        Exit Function
    End If
    DashOrValue = Trim(value)  
End Function

Function Notes(value)
    If value = "" Then
        Notes = ""
        Exit Function
    End If
    If UBound(Split(value,",")) > 0 Then
        Notes = Quotes(value)
    Else
        Notes = value
    End If
End Function


'parses the arguments passed in and places them in a global dictionary for easy access.
Function ParseArgs
    Dim namelessCount
    namelessCount = 0
    set args = CreateObject("Scripting.Dictionary") 'args are global

    Dim i
    For i=0 to WScript.Arguments.Count - 1
        Dim arg
        arg = WScript.Arguments.Item(i)
        If Left(arg,1) = "/" Or Left(arg,1) = "-" Then
            arg = Replace(arg,"/","")
            arg = Replace(arg,"-","")
            arg = Trim(arg)
            Dim parts
            parts = Split(arg,":")
            If UBound(parts) = 0 Then
                args.Add parts(0),""
            Else
                args.Add parts(0),parts(1)
            End If
        Else
            args.Add "arg" & CStr(namelessCount),arg
            namelessCount = namelessCount + 1
        End If
    Next

    ParseArgs = WScript.Arguments.Count
End Function




'Load the WIA CSV file into memory
'Returns a list of bands, that contains a list of repeaters. Each repeater entry is a dictionary
' eg bands(3)(32)("Call") will go to section 3, repeater number 32 and retrieve the Call entry as a string. Cool!
Function LoadWia(sourceCSV)
    Dim bands()
    LoadWia = bands

    Dim fso 
    set fso = CreateObject("Scripting.FileSystemObject")

    Dim file
    Set file = fso.OpenTextFile(sourceCSV, ForReading)
    If file.AtEndOfStream Then
        Exit Function
    End If

    'read in the header and get rid of all those extra quotes
    Dim header
    Dim i
    header = Split(Trim(Replace(file.ReadLine,"""","")),",") 
    For i=0 To UBound(header)
       header(i) = Trim(header(i)) 'Another Trim as one of the headers has an extra space at the end :-)
    Next

    'test that it is a WIA repeater file
    If header(0) <> "Output" And header(1) <> "Input" And header(2) <> "Call" Then
        wscript.echo sourceCSV & " is not a WIA repeater CSV file"
        Exit Function
    End If

    'read first line as it is a band seperator with commas everywhere and gives band information
    Dim bandSeparator
    bandSeparator = Split(Trim(Replace(file.ReadLine,"""","")),",")

    'load up every band
    Dim numBands
    numBands=0
    Do While file.AtEndOfStream <> True
        Dim band
        band = LoadWiaBand(file, header, bandSeparator)
        ReDim Preserve bands(numBands) 'expand the list
        bands(numBands) = band
        numBands = numBands + 1
    Loop
    file.Close

    LoadWia = bands 'return the whole structure
End Function


Function LoadWiaBand(file, header, bandSeparator)
    Dim repeater
    Dim repeaterDict
    Dim numRepeaters
    Dim band()

    numRepeaters = 0
    Do While file.AtEndOfStream <> True
        repeater = Split(Trim(Replace(file.ReadLine,"""","")),",") 'read in a repeater line from the file and split on a ,
        If UBound(repeater) > 2 Then 'skip illegal lines
            Dim i
            For i=0 To UBound(repeater) 'Trim up every field
                repeater(i) = Trim(repeater(i))
            Next
            'each band is seperated by and empty row
            If repeater(0) = "" And repeater(1) ="" And repeater(2) = "" Then
                bandSeparator = repeater
                LoadWiaBand = band
                Exit Function
            End If

            'create a repeater dictionary for each row keyed on the header
            set repeaterDict = CreateObject("Scripting.Dictionary")
            For i=0 to UBound(header)
                If i <= UBound(repeater) Then
                    If i < UBound(header) Then
                        repeaterDict.Add header(i), repeater(i) 
                    Else 'The note field can have extra , so we need to recombine them
                        Dim noteLine
                        noteLine = ""
                        Dim j
                        For j=i to UBound(repeater)
                            noteLine = noteLine & repeater(j) & ","
                        Next
                        noteLine = Left(noteLine,Len(noteLine)-1)
                        repeaterDict.Add header(i), noteLine 
                    End If
                Else
                    printMismatch(header)
                    printMismatch(repeater)
                    wscript.echo "Repeater has incorrect number of columms compared to header and has been skipped"
                    wscript.echo
                End If
            Next

            repeaterDict.Add "Tag",bandSeparator(14)

            'Into the band list goes the repeater dictionary
            ReDim Preserve band(numRepeaters)
            set band(numRepeaters) = RepeaterDict
            numRepeaters = numRepeaters + 1
        End If
    Loop
    LoadWiaBand = band
End Function

Sub printMismatch(entry)
    Dim Line
    Line = ""
    Dim i
    For i=0 to UBound(entry)
        Line = Line & entry(i) & ", "
    Next
    wscript.echo Line
End Sub

Function RepeaterCallsignInFilter(repeater)
     If Not args.Exists("f") Then 
         RepeaterCallsignInFilter = True
         Exit Function
     End If

    Dim parts
    parts = Split(args("f"),",")
    If UBound(parts) = -1 Then
         RepeaterCallsignInFilter = True
         Exit Function
    End If

    Dim i
    For i=0 to UBound(parts)
        If InStr(UCase(repeater("Call")),UCase(parts(i))) <> 0 Then
            RepeaterCallsignInFilter = True
            Exit Function
        End If
    Next

    RepeaterCallsignInFilter = False

End Function
